<!DOCTYPE html>
<html lang="<?php echo e(getLocale()); ?>" dir="<?php echo e(getLocale() == "ar" ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('favico/apple-icon-57x57.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('favico/apple-icon-60x60.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('favico/apple-icon-72x72.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('favico/apple-icon-76x76.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('favico/apple-icon-114x114.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('favico/apple-icon-120x120.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('favico/apple-icon-144x144.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('favico/apple-icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favico/apple-icon-180x180.png')); ?>">
    <link rel="icon" type="image/png" sizes="192x192" href="<?php echo e(asset('favico/android-icon-192x192.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('favico/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('favico/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('favico/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('favico/manifest.json')); ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('favico/ms-icon-144x144.png')); ?>">
    <meta name="theme-color" content="#ffffff">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(isset($title) ? trans('title.'.$title) : trans('app.title')); ?></title>


    <!-- Global stylesheets -->
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
          type="text/css">
    <link href="<?php echo e(asset('global_assets/css/icons/icomoon/styles.css')); ?>" rel="stylesheet" type="text/css">
    <?php if(getLocale() == "en"): ?>
        <link href="<?php echo e(asset('layout_1/LTR/material/full/assets/css/bootstrap.min.css')); ?>" rel="stylesheet"
              type="text/css">
        <link href="<?php echo e(asset('layout_1/LTR/material/full/assets/css/bootstrap_limitless.min.css')); ?>" rel="stylesheet"
              type="text/css">
        <link href="<?php echo e(asset('layout_1/LTR/material/full/assets/css/layout.min.css')); ?>" rel="stylesheet" type="text/css">
        <link href="<?php echo e(asset('layout_1/LTR/material/full/assets/css/components.min.css')); ?>" rel="stylesheet"
              type="text/css">
        <link href="<?php echo e(asset('layout_1/LTR/material/full/assets/css/colors.min.css')); ?>" rel="stylesheet" type="text/css">
    <?php elseif(getLocale() == "ar"): ?>
        <link href="<?php echo e(asset('layout_1/RTL/material/full/assets/css/bootstrap.min.css')); ?>" rel="stylesheet"
              type="text/css">
        <link href="<?php echo e(asset('layout_1/RTL/material/full/assets/css/bootstrap_limitless.min.css')); ?>" rel="stylesheet"
              type="text/css">
        <link href="<?php echo e(asset('layout_1/RTL/material/full/assets/css/layout.min.css')); ?>" rel="stylesheet" type="text/css">
        <link href="<?php echo e(asset('layout_1/RTL/material/full/assets/css/components.min.css')); ?>" rel="stylesheet"
              type="text/css">
        <link href="<?php echo e(asset('layout_1/RTL/material/full/assets/css/colors.min.css')); ?>" rel="stylesheet" type="text/css">
    <?php endif; ?>
<!-- /global stylesheets -->

    <!-- Core JS files -->
    <script src="<?php echo e(asset('global_assets/js/main/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/main/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/loaders/blockui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/ui/ripple.min.js')); ?>"></script>
    <!-- /core JS files -->

    <!-- Theme JS files -->
    <script src="<?php echo e(asset('global_assets/js/plugins/visualization/d3/d3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/visualization/d3/d3_tooltip.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/forms/styling/switchery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/forms/selects/bootstrap_multiselect.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/ui/moment/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/pickers/daterangepicker.js')); ?>"></script>

    <script src="<?php echo e(asset('global_assets/js/plugins/forms/selects/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/ui/moment/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/pickers/daterangepicker.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/pickers/anytime.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/pickers/pickadate/picker.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/pickers/pickadate/picker.date.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/pickers/pickadate/picker.time.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/pickers/pickadate/legacy.js')); ?>"></script>

    <script src="<?php echo e(asset('js/ckeditor.js')); ?>"></script>

    <?php if(getLocale() == "en"): ?>
        <script src="<?php echo e(asset('layout_1/LTR/material/full/assets/js/app.js')); ?>"></script>
    <?php elseif(getLocale() == "ar"): ?>
        <script src="<?php echo e(asset('layout_1/RTL/material/full/assets/js/app.js')); ?>"></script>
    <?php endif; ?>

<!-- Lang Translation -->
    <script src="<?php echo e(asset('messages.js')); ?>"></script>

    <style>
        @font-face {
            font-family: 'JF Flat';
            src: url('<?php echo e(asset('fonts/JF-Flat-regular.eot')); ?>');
            src: url('<?php echo e(asset('fonts/JF Flat Regular.otf')); ?>') format('otf'),
            url('<?php echo e(asset('fonts/JF-Flat-regular.ttf')); ?>') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: "JF Flat", Helvetica Neue, Helvetica, Arial, sans-serif;
            font-size: 13px;
            line-height: 1.5384616;
            color: #333333;
            background-image: '<?php echo e(asset('images/gplay.png')); ?>';
        }
    </style>
    <?php echo $__env->yieldContent('style'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>

</head>
<body>
<div id="app"></div>
<?php echo $__env->yieldContent('navbar'); ?>

<!-- Page content -->
<div class="page-content">

<?php echo $__env->yieldContent('sidebar'); ?>

<!-- Main content -->
    <div class="content-wrapper">

    <?php echo $__env->yieldContent('header'); ?>
    <?php echo $__env->yieldContent('content'); ?>

    <!-- Footer -->
        <div class="navbar navbar-expand-lg navbar-light">
            <div class="text-center d-lg-none w-100">
                <button type="button" class="navbar-toggler dropdown-toggle" data-toggle="collapse"
                        data-target="#navbar-footer">
                    <i class="icon-unfold mr-2"></i>
                    <?php echo e(trans('app.footer')); ?>

                </button>
            </div>

            <div class="navbar-collapse collapse" id="navbar-footer">
					<span class="navbar-text">
				 <a href="http://sourcecode-ai.com/">   <?php echo e(trans('app.title')); ?> </a> 	<?php echo e(trans('app.all right')); ?>    &copy; <?php echo e(date('Y')); ?>.
					</span>

                <ul class="navbar-nav ml-lg-auto">

                    <?php echo $__env->yieldContent('footer items'); ?>
                </ul>
            </div>
        </div>
        <!-- /footer -->
    </div>
    <!-- /main content -->

</div>
<!-- /page content -->
<script type="text/javascript">
    let APP_URL = '<?php echo json_encode(url('/')); ?>'
</script>

<script src="<?php echo e(asset('global_assets/js/plugins/notifications/jgrowl.min.js')); ?>"></script>
<script src="<?php echo e(asset('global_assets/js/plugins/notifications/noty.min.js')); ?>"></script>
<?php if(session()->has('message')): ?>
    <script>
        new Noty({
            theme: ' alert alert-<?php echo e(session()->get('class', 'success')); ?> alert-styled-left p-0 bg-white',
            text: '<?php echo session()->get('message'); ?> ',
            type: '<?php echo e(session()->get('class', 'success')); ?>',
            progressBar: false,
            timeout: 2500,
            closeWith: ['button']
        }).show();
    </script>

    <?php (session()->forget(['message' , 'class'])); ?>
<?php endif; ?>
<?php echo $__env->yieldContent('script'); ?>
<?php echo $__env->yieldPushContent('script'); ?>
</body>
</html>
<?php /**PATH /var/www/vhosts/eshhanli.sy/httpdocs/resources/views/layouts/app.blade.php ENDPATH**/ ?>