<?php $__env->startSection('content'); ?>

    <!-- Content area -->
    <div class="content d-flex justify-content-center align-items-center">

        <!-- Login form -->
        <form class="login-form" method="POST" action="<?php echo e(route('login')); ?>">
            <?php echo csrf_field(); ?>
            <div class="card mb-0">
                <div class="card-body">
                    <div class="text-center mb-3">
                        <img style="width: 50%; height: 50%;"
                             src="<?php echo e(asset('images/logo.png')); ?>" alt="<?php echo e(trans('app.title')); ?>">
                        <h5 class="mb-0"><?php echo e(__('app.login title')); ?></h5>
                        <span class="d-block text-muted"><?php echo e(__('app.login message')); ?></span>
                    </div>

                    <div class="form-group form-group-feedback form-group-feedback-left">
                        <input id="mobile" type="text" placeholder="<?php echo e(__('app.mobile')); ?>"
                               class="form-control<?php echo e($errors->has('mobile') ? ' is-invalid' : ''); ?>"
                               name="mobile" value="<?php echo e(old('mobile')); ?>" required autofocus>
                        <?php if($errors->has('mobile')): ?>
                            <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('mobile')); ?></strong>
                                    </span>
                        <?php endif; ?>

                        <div class="form-control-feedback">
                             <i class="icon-envelop text-muted"></i>
                        </div>

                    </div>

                    <div class="form-group form-group-feedback form-group-feedback-left">
                        <input id="password" type="password" placeholder="<?php echo e(__('app.password')); ?>"
                               class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>"
                               name="password" required>

                        <?php if($errors->has('password')): ?>
                            <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('password')); ?></strong>
                                    </span>
                        <?php endif; ?>

                        <div class="form-control-feedback">
                            <i class="icon-lock2 text-muted"></i>
                        </div>
                    </div>


                    <div class="form-group">
                        <button type="submit" class="btn btn-primary btn-block"><?php echo e(__('app.login')); ?><i
                                    class="icon-circle-<?php echo e(getLocale() == "ar" ? 'left2' : 'right2'); ?> ml-2"></i></button>
                    </div>

                    <div class="text-center">

                        <?php if(Route::has('password.request')): ?>
                            <a class="btn btn-link" href="<?php echo e(route('password.request')); ?>">
                                <?php echo e(__('app.forget password')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </form>
        <!-- /login form -->

    </div>
    <!-- /content area -->
<?php $__env->stopSection(true); ?>

<?php $__env->startSection('footer items'); ?>
    <?php if(getLocale() == "en"): ?>
        <li class="nav-item">
            <a rel="alternate" hreflang="ar" class="navbar-nav-link"
               href="<?php echo e(LaravelLocalization::getLocalizedURL("ar", null, [], true)); ?>">
                <i class="icon-earth mr-2"></i>
                العربية
            </a>
        </li>
    <?php else: ?>
        <li class="nav-item">
            <a rel="alternate" hreflang="en" class="navbar-nav-link"
               href="<?php echo e(LaravelLocalization::getLocalizedURL("en", null, [], true)); ?>">
                <i class="icon-earth mr-2"></i>
                English
            </a>
        </li>
    <?php endif; ?>
<?php $__env->stopSection(true); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASUS\Desktop\elrfaai-web\resources\views/auth/login.blade.php ENDPATH**/ ?>