<?php $__env->startSection('navbar'); ?>
    <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(true); ?>

<?php $__env->startSection('sidebar'); ?>
    <?php echo $__env->make('sidebar.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(true); ?>

<?php $__env->startSection('content'); ?>

    <div class="content">
        <h1>تقرير التحويلات</h1>
        <div class="card">
            <div class="card-header bg-info border-bottom-0">
                <i class="fa fa-search"></i>
                <span>بحث و فرز</span>
            </div>
            <div class="card-body">
                <?php echo e(Form::open(['method' => "get", "id" => "users-form"])); ?>

                <?php echo e(Form::token()); ?>


                <div class="row">

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="from_date" class="col-md-2 text-left">من تاريخ</label>
                            <div class="col-md-10">
                                <?php echo e(Form::date('from_date', old("from_date", $model->from_date), ['class' => 'form-control', 'id' => 'from_date'])); ?>

                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="to_date" class="col-md-2 text-left">الى تاريخ</label>
                            <div class="col-md-10">
                                <?php echo e(Form::date('to_date', old("to_date", $model->to_date), ['class' => 'form-control', 'id' => 'to_date'])); ?>

                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="city_id" class="col-md-2 text-left d-inline-block">اسم السائق :</label>
                            <div class="col-md-10">
                                <?php echo e(Form::select('driver_id',['0'=>'الكل']+$drivers,$model->driver_id, ['class' => 'form-control ', 'id' => 'driver_id'])); ?>

                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group row align-items-center">
                            <label for="city_id" class="col-md-2 text-left d-inline-block">اسم المستخدم :</label>
                            <div class="col-md-10">
                                <?php echo e(Form::select('client_id',['0'=>'الكل']+$clients,$model->client_id, ['class' => 'form-control ', 'id' => 'client_id'])); ?>

                            </div>
                        </div>
                    </div>


                </div>
                <div class="d-flex justify-content-between">
                    <div>
                    </div>
                    <div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-filter"></i>
                            <span>فرز النتائج</span>
                        </button>
                        <a href="<?php echo e(route('statistics' , "userReport")); ?>" class="btn btn-danger">
                            <i class="fa fa-ban"></i>
                            <span>اعادة تعيين</span>
                        </a>
                    </div>
                </div>
                <?php echo e(Form::close()); ?>

            </div>
        </div>


        <div class="card">


            <div class="card-body">


                <div class="table-responsive">
                    <?php if($items->count() > 0): ?>
                        <table class="table table-bordered datatable-basic" lang="ar" dir="rtl">
                            <thead class="bg-primary">
                            <tr>
                                <th>نوع الشحنة</th>
                                <th>اسم السائق</th>
                                <th>اسم المستخدم</th>
                                <th>تاريخ الشحنة</th>
                                <th>تـكلفة الشحنة</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->type); ?></td>
                                    <td><?php echo e(optional($item->driver)->name); ?></td>
                                    <td><?php echo e(optional($item->user)->name); ?></td>
                                    <td><?php echo e($item->created_at->format('Y-m-d')); ?></td>
                                    <td><?php echo e($item->cost); ?> <?php echo e(trans('front.ils')); ?></td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                            <tr class="bg-primary">
                                <td colspan="4">المجموع</td>
                                <td><b><?php echo e($total); ?></b> <?php echo e(trans('front.ils')); ?></td>
                            </tr>
                            </tfoot>
                        </table>
                    <?php else: ?>
                        <div class="alert alert-info alert-styled-left">
                            <i class="fa fa-info-circle"></i><?php echo trans('app.no items message'); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('modals.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(true); ?>

<?php $__env->startSection('style'); ?>
    <style href="<?php echo e(asset('global_assets/js/plugins/tables/datatables/dataTables.bootstrap4.min.css')); ?>"></style>
    <style
        href="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.bootstrap4.min.css')); ?>"></style>
<?php $__env->stopSection(true); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/datatables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/dataTables.bootstrap4.min.js')); ?>"></script>
    <script
        src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/buttons/dataTables.buttons.min.js')); ?>"></script>
    <script
        src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/jszip/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/pdfmake/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/pdfmake/vfs_fonts.min.js')); ?>"></script>
    <script
        src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.html5.min.js')); ?>"></script>
    <script
        src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.print.min.js')); ?>"></script>
    <script
        src="<?php echo e(asset('global_assets/js/plugins/tables/datatables/extensions/buttons/buttons.colVis.min.js')); ?>"></script>

    <script>

        let table = $('.datatable-basic').DataTable({
            "pageLength": 5,
            dom: 'Bfrtip',
            "aaSorting": [[2, 'desc']],
            buttons: [
                {
                    extend: 'excel',
                    text: '  <i class="icon-file-excel"></i>  إكسل',
                    className: '',
                    header: true
                }
            ],
            pagingType: "numbers",
            language: {
                search: '<span>البحث:</span> _INPUT_',
                info: '',

                searchPlaceholder: 'بحث',
                lengthMenu: '<span>عرض:</span> _MENU_',
            }
        });
    </script>
<?php $__env->stopSection(true); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\ASUS\Desktop\Eshhanli1\resources\views/reports/usereport.blade.php ENDPATH**/ ?>