<!-- Iconified modal -->
<div id="approve-modal" class="modal fade" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="icon-file-eye mr-2"></i> &nbsp;<?php echo e(trans('app.approve')); ?></h5>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <div class="modal-body">
                <div
                        class="alert alert-dismissible alert-styled-left border-top-0 border-bottom-0 border-right-0"
                        id="approve-modal-message">
                    <?php echo trans('app.approve order'); ?>

                </div>
                <hr>
                <form id="approve-form" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="alert-div"></div>
                    <label  ><?php echo e(trans('app.cost')); ?> : </label>
                    <input style="border: gainsboro" type="text" name="cost" id="approve-modal-id">
                    <br>
                    <label><?php echo e(trans("app.driver name")); ?></label>
                    <select name="driver_id" id="">
                        <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($driver->id); ?>"><?php echo e($driver->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <br>
                    <label><?php echo e(trans("app.received date")); ?></label>
                    <input type="date" name="received_date" >

                </form>
            </div>

            <div class="modal-footer">
                <button class="btn btn-link" data-dismiss="modal"><i
                            class="icon-cross2 font-size-base mr-1"></i> <?php echo e(trans('app.close')); ?></button>
                <button type="submit" form="approve-form" class="btn bg-info-300"><i
                            class="icon-file-eye font-size-base mr-1"></i> <?php echo e(trans('app.approve')); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- /iconified modal -->


<?php $__env->startPush('script'); ?>
    <script>
        $('.btn-approve').on('click', function () {
            let id = $(this).data('id');
            let modal = $(this).data('modal');
            let action = "<?php echo e(url('/'.getLocale().'/admin')); ?>";

            action += '/' + modal + '/'+ id + '/'+ 'approved';

            $("#approve-form").attr('action', action);
            $('#approve-modal-id').val(id);
        });


    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/eshhanli/application/resources/views/modals/approve-modal.blade.php ENDPATH**/ ?>