<?php

use App\Http\Controllers\APIController;
use App\Http\Controllers\AuthController;
use App\Trip;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;

//Driver Register
Route::post('/register', [AuthController::class, 'register']);
Route::post('/image/base64', [AuthController::class, 'storeImage']);
Route::post("/check/number", [AuthController::class, "checkNumber"]);
Route::post("/login", [AuthController::class, "login"]);
Route::post("/verify/code/check", [AuthController::class, "verifyCodeCheck"]);


Route::middleware('auth:api')->group(function () {
    Route::get("/user/information", [AuthController::class, "userInformation"]);
    Route::get("/options", [APIController::class, "getOptions"]);
    Route::get("/orders", [APIController::class, "getOrders"]);
    Route::get("/notifications", [APIController::class, "getNotifications"]);
    Route::get("/services", [APIController::class, "serviceDetails"]);
   
 
    Route::post("/logout", [AuthController::class, "logout"]);
    Route::post("/fcmtoken", [AuthController::class, "fcmToken"]);
    Route::post("/order/new", [APIController::class, "newOrder"]);
    Route::post("/order/update", [APIController::class, "orderUpdate"]);
    Route::post("/order/rating", [APIController::class, "orderRating"]);
    Route::post("/user/update", [AuthController::class, "userUpdate"]);

});


Route::post("/mobileCode", [APIController::class, "getCode"]);
Route::post("/checkCode", [APIController::class, "checkCode"]);
 Route::get("/privacy", [APIController::class, "privacy"]);

