@extends('layouts.app')

@section('navbar')
    @include('partials.navbar')
@overwrite

@section('sidebar')
    @include('sidebar.index')
@overwrite

@section('content')
    <div class="content">
        <form id="create-form" method="post" action="{{route('users.update',Auth::id())}}"
              enctype="multipart/form-data">
            @csrf
            @method('put')
            <div class="card">
                <div class="card-body">
                    <fieldset class="mb-3">
                        <legend class="text-uppercase font-size-sm font-weight-bold">{{trans('app.attribute')}}</legend>
                        @foreach($attributes as $attribute => $type)
                            <div class="form-group row">
                                <label class="col-form-label col-lg-3">{{trans('attributes.'.$attribute)}}</label>
                                <div class="col-lg-9">
                                    @switch($type)
                                        @case("select")
                                        @include('inputs.select' , ['item' => $item])
                                        @break
                                        @case("options")
                                        @include('inputs.options' , ['item' => $item])
                                        @break
                                        @case("textarea")
                                        @include('inputs.textarea' , ['item' => $item])
                                        @break
                                        @case("location")
                                        @include('inputs.location' , ['item' => $item])
                                        @break
                                        @case("boolean")
                                        @include('inputs.boolean' , ['item' => $item])
                                        @break
                                        @case("image")
                                        <a href="#" class="list-icons-item btn-view" data-toggle="modal"
                                           data-trigger="hover" data-path="{{$item->$attribute}}"
                                           data-target="#view-file-modal">
                                            <i class="icon-eye"></i>
                                        </a>
                                        @include('inputs.image' , ['item' => $item])
                                        @break
                                        @case("images")
                                        @foreach($item->images()->get() as $image)
                                            <a href="#" class="list-icons-item btn-view" data-toggle="modal"
                                               data-trigger="hover" data-path="{{$image->path}}"
                                               data-target="#view-file-modal">
                                                <i class="icon-eye"></i>
                                            </a>
                                        @endforeach
                                        @include('inputs.images' , ['item' => $item])
                                        @break
                                        @default
                                        @include('inputs.text' , ['item' => $item])
                                        @break
                                    @endswitch
                                    @if(!in_array($type , ["image" , "location"]) && $errors->has($attribute))
                                        <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first($attribute) }}</strong>
                                                </span>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </fieldset>
                    <a href="javascript:;" style="width: 100%;
                    text-align: center;
                    display: block;" data-target="#passwordresetmodal" data-toggle="modal">@lang('app.password reset') <i class="icon-lock"></i></a>

                </div>
                <div class="card-footer text-right">
                    <button type="submit" form="create-form" class="btn btn-primary">{{trans('app.save')}} <i
                                class="icon-paperplane ml-2"></i></button>
                </div>
            </div>
        </form>
    </div>
    <div id="passwordresetmodal" class="modal fade" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="icon-lock mr-2"></i> &nbsp;{{trans('app.password reset')}}</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    {{-- <div class="alert alert-danger alert-dismissible alert-styled-left border-top-0 border-bottom-0 border-right-0"
                         id="delete-modal-message">
                        {!! trans('app.delete message') !!}
                    </div> --}}
                    {{--
                    <h6 class="font-weight-semibold"><i class="icon-warning mr-2"></i>{{trans('app.warning')}}</h6>
                    <p id="warning-modal-message">{!! trans('app.warning message') !!}</p>

                    <hr> --}}
                    <form id="reset-password-form" class="reset-password-form" action="{{route('reset-password')}}" method="post">
                        <div class="alert-div"></div>
                        @csrf
                        <div class="form-group row">
                            <label class="col-form-label col-lg-3">@lang('app.old password')</label>
                            <div class="col-lg-9">
                                <input class="form-control"
                                    type="password" name="old_password"
                                     autofocus>
                            </div>

                            <label class="col-form-label col-lg-3">@lang('app.new password')</label>
                            <div class="col-lg-9">
                                <input class="form-control mb-1"
                                    type="password" name="password"
                                     autofocus>
                                     <div id="password-patterns" class="alert alert-danger p-0" style="display: none">
                                        <ul>
                                            @if (app()->getLocale() === 'ar')
                                                <li>كلمة المرور يجب أن تكون على الأقل 8 محارف</li>
                                                <li>رقم واحد على الأقل</li>
                                                <li>حرف كبير واحد على الأقل</li>
                                                <li>رمز واحد على الاقل [!@#$%^&*]</li>
                                            @else
                                                <li>Password must contain at least 8 characters</li>
                                                <li>Password must contain 1 number at least</li>
                                                <li>Password must contain at least one capital letter</li>
                                                <li>Password must contain at least one symbol [!@#$%^&*]</li>
                                            @endif
                                        </ul>
                                     </div>
                            </div>

                            <label class="col-form-label col-lg-3">@lang('app.confirmed new password')</label>
                            <div class="col-lg-9">
                                <input class="form-control mb-1"
                                    type="password" name="password_confirmation"
                                     autofocus>
                                     <div id="not-confirmed" class="alert alert-danger p-1" style="display: none">
                                        @lang('app.not confirmed password')
                                     </div>
                            </div>
                        </div>


                    </form>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-link" data-dismiss="modal"><i
                                class="icon-cross2 font-size-base mr-1"></i> {{trans('app.close')}}</button>
                    <button type="submit" id="submit-passowrd-form" form="reset-password-form" class="btn bg-success" disabled >{{trans('app.save')}} <i
                                class="icon-paperplane font-size-base mr-1"></i></button>
                </div>
            </div>
        </div>
    </div>
    @include('modals.view-file-modal')
@overwrite

@push('script')
    <script>
        let passed = false;
        let confirmed = false;
        $('input[name=password]').on('keyup' , function(){
            let reg = new RegExp('^(?=.*[0-9])(?=.*[A-Z])(?=.*[!@#$%^&*])[a-zA-Z0-9!@#$%^&*]{6,16}$');
            const alert = $('#password-patterns');
            let value = $(this).val();
            if(reg.test(value) && value.length >= 8){
                alert.fadeOut();
                passed = true;
            } else {
                alert.fadeIn();
            }
        });

        $('input[name=password_confirmation]').on('keyup' , function(){

            const alert = $('#not-confirmed');
            let value = $('input[name=password]').val();
            if($(this).val() == value){
                alert.fadeOut();
                confirmed = true;
            } else {
                alert.fadeIn();
            }

            if(passed && confirmed && $('input[name=old_password]').val()){
                $('#submit-passowrd-form').attr('disabled' , false);
            } else {
                $('#submit-passowrd-form').attr('disabled' , true);
            }
        });

        $(document).on('click', '#submit-passowrd-form',function(){
            $('#reset-password-form').submit();
        });
    </script>
@endpush
