@extends('layouts.front')

@section('content')

    <section id="login" class="add-project pos-relative pt-5 register login grey3-bg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 offset-lg-1 col-12 add-form">
                    <form method="post" action="{{route('login')}}"
                          class="row mr-0 ml-0 w-100 shadow radius-30 white-bg wrap">
                        @csrf
                        <div class="col-12 mb-4">
                            <div class="d-block w-100 form-logo">
                                <img src="{{asset('front/imgs/logo.png')}}"
                                     style="width: 250px"/></div>
                        </div>
                        <div class="col-12 mb-2">
                            <span class="f-big main-text f-bold">{{trans('front.welcome')}}</span>
                        </div>
                        <div class="col-12 pb-3 mb-4 def-border-bottom">
                            <span class="f-extramedium f-med">{{trans('front.enter you account')}}</span>
                        </div>
                        <div class="col-lg-12 col-12">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.email')}} <span class="main-text">*</span>
                                </label>
                                <input value="{{old('email')}}" required name="email" type="email"
                                       class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}">
                                @if ($errors->has('email'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-12 col-12">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.password')}} <span class="main-text">*</span>
                                </label>
                                <input required name="password" type="password"
                                       class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}">
                                @if ($errors->has('password'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-12 p-0 mb-3">
                            <div class="w-100 row m-0 align-items-lg-center">
                                <div class="col-lg-6 col-12">
                                    <div class="w-100 m-lg-0 form-group">
                                        <label class="mouse">
                                            <span class="mr-2"><input name="remember_me" type="checkbox" class="aa-check-select"/></span>
                                            <span class="pt-1">{{trans('front.keep me')}}</span>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-12 txt-lg-right">
                                    <a href="{{route('password.request')}}" class="d-inline-block main-text f-normal"
                                       data-toggle="tooltip"
                                       title="{{trans('front.recover it')}}">{{trans('front.forget')}}</a>
                                </div>
                            </div>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="butn main-butn f-medium next">
                                <span>{{trans('front.login')}}</span>
                            </button>
                        </div>
                        <div class="col-12">
                            <a href="{{route('register')}}" class="d-inline-block main-text f-normal mt-3"
                               data-toggle="tooltip"
                               title="{{trans('front.let us')}}">{{trans('front.register')}}</a>
                        </div>

                    </form>
                </div>
                <div class="col-lg-5 col-12">
                    <div class="w-100 h-100 img">
                        <img src="{{asset('front/imgs/icons/login.png')}}" class="w-100"/>
                    </div>
                </div>
            </div>
        </div>
    </section>

@overwrite
