<?php

namespace App;

use Laravel\Passport\HasApiTokens;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable  implements MustVerifyEmail
{
    use HasApiTokens, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    public $fillable = [
        'id','first_name', 'last_name', 'email' ,'mobile', 'password', 'image', 'role', 'status', 'balance',"verify_code"
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'mobile_verified_at' => 'datetime',
        'verify_code' => 'integer',
    ];

    public function routeNotificationForFcm()
    {
        return $this->fcm_token;
    }

    public function findForPassport($username)
    {
        return $this->where('mobile', $username)->first();
    }

    public function getNameAttribute()
    {
        return $this->first_name . " " . $this->last_name;
    }

    public function orders()
    {
        return $this->hasMany(Order::class, "client_id");
    }

    public function driversOrders()
    {
        return $this->hasMany(Order::class, "driver_id");
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class, "user_id");
    }

    public function states()
    {
        return $this->hasMany(State::class, "user_id");
    }

    public function ratings()
    {
        return $this->hasMany(Rating::class, "user_id");
    }


}
