<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Rating extends Model
{
    use HasTranslations;

    protected $fillable = [
        "rating", "description", "user_id", "order_id"
    ];

    public $translatable = ["description"];

    public function order()
    {
        return $this->belongsTo(Order::class, "order_id");
    }

    public function user()
    {
        return $this->belongsTo(User::class, "user_id");
    }
}
