<?php

namespace App\Notifications;

use App\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Yusef\Channels\FirebaseMessage;

class RejectOrderNotification extends Notification
{
    use Queueable;
    protected $order;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['fcm'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    public function toFcm()
    {
        $title = "";
        $body = "";

        if ($this->order->user->lang == "ar") {
            $title = "رفض الطلب";
            $body = "تم رفض الطلب من قبل الإدارة";
        }elseif($this->order->user->lang == "en") {
           $title = "Order Rejected";
           $body = "Your Order has been rejected by the admins";
        }

        $data =[
            "type"=>"reject_order_notification",
            "title"=> $title,
            "body"=> $body,
            "order_id" =>$this->order->id
        ];

        $message = new FirebaseMessage();
        $message->data($data);

        $message->priority(FirebaseMessage::PRIORITY_HIGH);

        return $message;
    }
}
