<?php

namespace App\Notifications;

use App\Order;
use App\State;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Yusef\Channels\FirebaseMessage;

class OngoingNotification extends Notification
{
    use Queueable;
    protected $order, $state, $details_ar, $details_en;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Order $order, State $state, $details_ar, $details_en)
    {
        $this->order = $order;
        $this->state = $state;
        $this->details_ar = $details_ar;
        $this->details_en = $details_en;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['fcm'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    public function toFcm()
    {
        $title = "";
        $body = "";
        $description = $this->state->details ? $this->state->details : " ";

        if ($this->order->user->lang =="ar") {
            $title = "قيد  التوصيل";
            $body = "إن طلبكم قيد التوصيل : ".$this->details_ar;
        }elseif ($this->order->user->lang == "en") {
            $title = "Delivery";
            $body = "Your order in delivery : ".$this->details_en;
        }

        $data =[
            "type"=>"on_going_order_notification",
            "title"=> $title,
            "body"=> $body,
            "order_id" =>$this->order->id
        ];

        $message = new FirebaseMessage();
        $message->data($data);

        $message->priority(FirebaseMessage::PRIORITY_HIGH);

        return $message;
    }
}
