<?php

namespace App\Notifications;

use App\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Yusef\Channels\FirebaseMessage;

class ConfirmNotification extends Notification
{
    use Queueable;
    protected $order;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['fcm'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    public function toFcm()
    {
        $title = "";
        $body = "";
        if ($this->order->user->lang == "ar") {
            $title = "تأكيد الطلب";
            $body = "إن طلبكم قيد التأكيد من قبلكم, التكلفة :".$this->order->cost;
        }elseif($this->order->user->lang == "en") {
            $title = "Confirm Order";
            $body = "Your order waiting confirm by your, The Cost : ".$this->order->cost;
        }

        $data =[
            "type"=>"accept_order_notification",
            "order_id"=>$this->order->id,
            "title"=>$title ,
            "body"=> $body,
//            "name"=> $this->order->driver->name,
//            "mobile"=> $this->order->driver->mobile,
        ];

        $message = new FirebaseMessage();
        $message->data($data);

        $message->priority(FirebaseMessage::PRIORITY_HIGH);

        return $message;
    }
}
