<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Notification extends Model
{
    use HasTranslations;

    protected  $table = "notifications";

    protected $fillable = [ "user_id", "title", "body", "order_id" ];

    public $translatable = ["title", "body"];

    public function user()
    {
        return $this->belongsTo(User::class, "user_id");
    }

}
