<?php

namespace App\Http\Resources;

use App\Option;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $status = Option::where("code", $this->status)->first();
        $type_of_payment = Option::where("code", $this->type_of_payment)->first();
        $type = Option::where("code", $this->type)->first();

        return [
            "id"=>$this->id,
            "type"=>$type ? $type->text : '',
            "from"=>$this->from,
            "to"=>$this->to,
            "type_of_payment"=>$type_of_payment ? $type_of_payment->text : '',
            "is_breakable"=>$this->is_breakable,
            "height"=>$this->height,
            "length"=>$this->length,
            "width"=>$this->width,
            "weight"=>$this->weight,
            "size"=>$this->size,
            "name"=>$this->name,
            "mobile"=>$this->mobile,
            'status' => $status ? $status->text : '',
            'rating' => $this->rating,
            'cost' => $this->cost,
            'received_date' => $this->received_date,
            'description' => $this->discreption,
            'number_of_packages' => $this->number_of_packages,
            'package_content' => $this->package_content,
            "states" => $this->states
        ];
    }
}
