<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            "id"=>$this->id,
            "type"=>$this->type,
            "title"=>$this->title,
            "body"=>$this->body,
            "order_id"=>$this->order_id,
            "created_at" =>$this->created_at->diffForHumans()
        ];
    }
}
