<?php


namespace App\Http\Requests;


use App\Language;
use Illuminate\Foundation\Http\FormRequest;

class StoreState extends FormRequest
{
    public function rules()
    {
        $rules = [
            "order_id"=>"required",
        ];

        foreach (Language::all() as $language) {
            $attr = "details_" . $language->code;
            $rules[$attr] = 'required';
        }

        return $rules;
    }

    public function messages()
    {
        return [
            "order_id.required"=>trans("validation.required"),
            "user_id.required"=>trans("validation.required"),
            "status.required"=>trans("validation.required"),
        ];
    }

}