<?php


namespace App\Http\Requests;


use App\Language;
use Illuminate\Foundation\Http\FormRequest;

class StoreService extends FormRequest
{
    public function rules()
    {
        $rules = [
            "image"=>"required"
        ];

        foreach (Language::all() as $language) {
            $attr = "title_" . $language->code;
            $rules[$attr] = 'required';
            $attr = "description_" . $language->code;
            $rules[$attr] = 'required';
        }

        return $rules;
    }


    public function messages()
    {
        return [
            "image.required" => trans("validation.required")
        ];
    }
}