<?php

namespace App\Http\Requests;

use App\Language;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class StoreNotification extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return in_array(Auth::user()->role, ["admin", "entry"]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [];

            foreach (Language::all() as $language) {
                $attr = "title_" . $language->code;
                $rules[$attr] = 'required';
                $attr = "body_" . $language->code;
                $rules[$attr] = 'required';
            }

        return $rules;
    }

    public function messages()
    {
        return [ ];
    }
}
