<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreFinishedOrder extends FormRequest
{
    public function rules()
    {
        return [
            'driver_id' => 'required',
            'type' => 'required',
            'from' => 'required',
            'to' => 'required',
            'type_of_payment' => 'required',
            "cost"=>"required",
            "package_content"=>"required",
            "number_of_packages"=>"required|integer",

        ];
    }

    public function messages()
    {
        return [
            'driver_id.required'=>trans('validation.required'),
            'type.required'=>trans('validation.required'),
            'from.required'=>trans('validation.required'),
            'to.required'=>trans('validation.required'),
            'type_of_payment.required'=>trans('validation.required'),
            'cost.required'=>trans('validation.required'),
            'package_content.required'=>trans('validation.required'),
            'number_of_packages.integer'=>trans('validation.integer'),
        ] ;
    }

}
