<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDriver extends FormRequest
{
    public function rules()
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'password' => 'required',
            'mobile' => 'required|unique:users',
            'image' => 'required',

        ];
    }

    public function messages()
    {
        return [
            'first_name.required'=>trans('validation.required'),
            'last_name.required'=>trans('validation.required'),
            'password.required'=>trans('validation.required'),
            'mobile.required'=>trans('validation.required'),
            'mobile.unique'=>trans('validation.unique'),
            'image.required'=>trans('validation.required'),

        ] ;
    }
}
