<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreAdmin extends FormRequest
{
    public function rules()
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'password' => 'required',
            'image' => 'required',
            'mobile' => 'required|unique:users',

        ];
    }

    public function messages()
    {
        return [
            'first_name.required'=>trans('validation.required'),
            'last_name.required'=>trans('validation.required'),
            'password.required'=>trans('validation.required'),
            'image.required'=>trans('validation.required'),
            'mobile.required'=>trans('validation.required'),
            'mobile.unique'=>trans('validation.unique'),

        ] ;
    }
}
