<?php

namespace App\Http\Controllers;


use App\Http\Form\OrderFilter;
use App\Http\Form\OrdersStatusFilter;
use App\Http\Form\TransactionFilterForm;
use App\Http\Form\TripFilterForm;
use App\Http\Form\UserFilter;
use App\Option;
use App\Order;
use App\User;
use Illuminate\Support\Facades\DB;

class StatisticController extends Controller
{
    public function report($type)
    {
        switch ($type) {
            case "finance":

                $title = 'التقرير المالي للشحنات ضمن مدة محددة';

                $query = Order::query();


                $model = new OrderFilter();
                $model->setAttributes(request()->all());
                if (!empty($model->from_date)) {
                    $query->whereDate("created_at", ">=", $model->from_date);
                }

                if (!empty($model->to_date)) {
                    $query->whereDate("created_at", "<=", $model->to_date);
                }

                if (!empty($model->type_of_payment)) {
                    $query->where('type_of_payment', $model->type_of_payment);
                }

                $items = $query->orderByDesc('created_at')->get();

                $all_total = 0;
                foreach ($items as $item) {
                    $all_total += $item->cost;
                }

                $website_total = $all_total;

                $type = "finance";

                return view('reports.finance')->with(
                    [
                        "title" => $title,
                        "route" => "statistics",
                        "drivers" => User::where('role', 'driver')->get()->pluck('name', 'id')->toArray(),
                        "payments" => Option::where('type', 'type_of_payment')->get()->pluck('text', 'code')->toArray(),
                        "items" => $items,
                        "params" => null,
                        "model" => $model,
                        "type" => $type,
                        "website_total" => $website_total,
                        "all_total" => $all_total,
                        "actions" => [],
                    ]
                );

                break;

            case "userReport":
                $title = 'تقرير الشحنات لمستخدم  محدد';
                $query = Order::query();

                $model = new UserFilter();
                $model->setAttributes(request()->all());

                if (!empty($model->from_date)) {
                    $query->whereDate("created_at", ">=", $model->from_date);
                }

                if (!empty($model->to_date)) {
                    $query->whereDate("created_at", "<=", $model->to_date);
                }

                if (!empty($model->client_id)) {
                    $query->where("client_id", $model->client_id);
                }

                if (!empty($model->client_id)) {
                    $query->where("client_id", $model->client_id);
                }
                if (!empty($model->driver_id)) {
                    $query->where("driver_id", $model->driver_id);
                }

                $items = $query->orderByDesc('created_at')->get();

                $total = 0;
                foreach ($items as $item) {
                    $total += $item->cost;
                }

                $type = "userReport";

                $options = Option::where("type", "type_of_payment")->get();

                return view('reports.usereport')->with(
                    [
                        "title" => $title,
                        "route" => "statistics",
                        "orders" => Order::all()->toArray(),
                        "clients" => User::where('role',"user")->get()->pluck('mobile', 'id')->toArray(),
                        "drivers" => User::where('role', "driver")->get()->pluck('name', 'id')->toArray(),
                        "options" => $options,
                        "items" => $items,
                        "params" => null,
                        "model" => $model,
                        "type" => $type,
                        "total" => $total,
                        "actions" => [],
                    ]
                );

                break;

            case "ordersTypes":

                $title = 'تقرير الرحلات في منطقة معينة';

                $query = Order::query();

                $model = new OrdersStatusFilter();
                $model->setAttributes(request()->all());

                if (!empty($model->from_date)) {
                    $query->whereDate("created_at", ">=", $model->from_date);
                }

                if (!empty($model->to_date)) {
                    $query->whereDate("created_at", "<=", $model->to_date);
                }


                if (!empty($model->status)) {
                    $query = $query->where("status", $model->status);
                }

                $query = $query->orderByDesc("created_at");
                $items = $query->get();

                $total = 0;
                foreach ($items as $item)
                {
                    $total = $total + $item->cost;
                }

                $type = "ordersTypes";

                return view('reports.ordersTypes')->with(
                    [
                        "title" => $title,
                        "route" => "statistics",
                        "clients" => User::where('role', 'user')->get()->pluck('name', 'id')->toArray(),
                        "status" => Option::where("type", 'order_status')->get()->pluck('text', 'code')->toArray(),
                        "items" => $items,
                        "params" => null,
                        "model" => $model,
                        "type" => $type,
                        "total" => $total,
                        "actions" => [],
                    ]
                );
                break;

            default :
                return redirect()->to('404');
        }
    }
}
