<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreState;
use App\Http\Requests\UpdateState;
use App\Language;
use App\Notifications\OngoingNotification;
use App\Order;
use App\State;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class StateController extends CrudController
{
    public function __construct(State $state)
    {
        $this->model = $state;
        $this->route = "states";
        $this->title = "states";

        $this->table_attributes = [
            "order_id" => "select",
            "details" => "translatable_text",
        ];

        $this->attributes = [
            "order_id" => "select",
            "details" => "translatable_text",
        ];

        $this->storeRequest = new StoreState();
        $this->updateRequest = new UpdateState();

        parent::__construct();
    }


    public function store(Request $request)
    {
        $storeRequest = new StoreState();
        $this->validate($request, $storeRequest->rules());
        $updateRequest = new UpdateState();
        $this->validate($request, $updateRequest->rules());

        $details_ar = "";
        $details_en = "";
        $order = Order::find($request->order_id);

        $state = new State();
        $state->user_id = $request->user_id;
        $state->order_id = $order->id;
        $state->status = $order->status;
//        $state->details = $request->details;
        $details_ar = $request->details_ar;
        $details_en = $request->details_en;

        if (!is_null($state->translatable)) {
            foreach ($state->translatable as $attr) {
                $trans = [];
                foreach (Language::all() as $language) {
                    $var = $attr . "_" . $language->code;
                    if ($var == "details_ar") {
                        $trans[$language->code] = $details_ar;
                    } elseif ($var == "details_en") {
                        $trans[$language->code] = $details_en;
                    }
                }
                $state->$attr = $trans;
            }
        }
        $state->save();
        $order->user->notify(new OngoingNotification($order, $state, $details_ar, $details_en));


        Session::flash('message', trans('app.success message', ['action' => trans('app.update')]));
        Session::flash('class', 'success');
        return redirect()->route("states.index");
    }


}
