<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePrivacy;
use App\Post;
use Illuminate\Http\Request;

class PostController extends CrudController
{
    public function __construct(Post $post)
    {
        $this->model = $post;
        $this->route = "posts";
        $this->title = "posts";

        if (\request()->has("type") && \request("type")== "privacy")
            $this->title = "privacy";
        elseif (request()->has("type") && \request("type")== "about") {
            $this->title = "about";
        }

        $this->table_attributes = [
            'title' => 'translatable_text',
            'body' => 'translatable_text'
        ];

        $this->attributes = [
            'title' => 'translatable_text',
            'body' => 'translatable_text'
        ];

        $this->storeRequest = new StorePrivacy();
        $this->updateRequest = new StorePrivacy();

        parent::__construct();

    }
}
