<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreOption;
use App\Language;
use App\Option;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use League\Flysystem\Exception;

class OptionController extends CrudController
{
    public function __construct(Option $option)
    {
        $this->model = $option;
        $this->route = 'options';

        if (\request()->has("type") && \request('type')== "type_of_freight")
             $this->title = 'type of freight';

        if (\request()->has("type") && \request('type')== "type_of_payment")
            $this->title = 'type of payments';
        $this->table_attributes = [
            "text" => "text",
        ];

        $this->attributes = [
            "text" => "translatable_text",
        ];

        $this->storeRequest =new StoreOption();

        parent::__construct();
    }


    public function store(Request $request)
    {
        $storeRequest = new StoreOption();
        $this->validate($request,$storeRequest->rules());

        try {
            $item = $this->model;;

            if (isset($this->model->translatable)) {
                $item->fill($request->except($this->model->translatable));

                foreach ($this->model->translatable as $attr) {
                    $trans = [];
                    foreach (Language::all() as $language) {
                        $var = $attr . "_" . $language->code;
                        $trans[$language->code] = $request->$var;
                    }
                    $item->$attr = $trans;
                }
            } else {
                $item->fill($request->all());
            }


            $item->code = $request->text_en;

            $item->save();

            Session::flash('message', trans('app.success message', ['action' => trans('app.create')]));
            Session::flash('class', 'success');

        if ($this->route == "options")
                return redirect()->to(url('admin/'.$this->route, $item->id ). "?type=" . $item->type);
            return redirect()->route($this->route . '.show', $item->id);

        } catch
        (Exception $e) {
            Session::flash('message', trans('app.error message', ['action' => trans('app.create')]));
            Session::flash('class', 'danger');

            return redirect()->back();
        }
    }
}
