<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreNotification;
use App\Http\Requests\StoreUserNotification;
use App\Language;
use App\Notification;
use App\Notifications\AdminNotification;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;


class NotificationController extends CrudController
{
    public function __construct(Notification $notification)
    {
        $this->model = $notification;
        $this->route = "notifications";
        $this->title = "notifications";

        $this->storeRequest = new StoreUserNotification();
        $this->updateRequest = new StoreUserNotification();

        parent::__construct();
    }

    public function broadcast()
    {
        $data = [];

        $this->attributes = [
            "title" => "translatable_text",
            "body" => "translatable_text",
        ];

        return view('layouts.create')->with([
            "title" => $this->title,
            "route" => $this->route,
            "attributes" => $this->attributes,
            "data" => $data,
            "action" => "create",
            "params" => [],
        ]);
    }

    public function index()
    {
        $data = [];

        $this->attributes = [
            "user_id" => "select",
            "title" => "translatable_text",
            "body" => "translatable_text",
        ];

        return view('layouts.create')->with([
            "title" => $this->title,
            "route" => $this->route,
            "attributes" => $this->attributes,
            "data" => $data,
            "action" => "create",
            "params" => [],
        ]);
    }

    public function store(Request $request)
    {
        if ($request->has("user_id")) {
            $storeRequest = new StoreUserNotification();
            $this->validate($request, $storeRequest->rules());
        }else {
            $storeRequest = new StoreNotification();
            $this->validate($request, $storeRequest->rules());
        }

        $notification = new Notification();

        try {
            if ($request->has("user_id")) {
                $user = User::find($request->user_id);

                $notification = new Notification();
                $notification->fill($request->except($notification->translatable));
                if (!is_null($notification->translatable)) {
                    foreach ($notification->translatable as $attr) {
                        $trans = [];
                        foreach (Language::all() as $language) {
                            $var = $attr . "_" . $language->code;
                            $trans[$language->code] = $request->$var;
                        }
                        $notification->$attr = $trans;
                    }
                }
                $notification->type = "Admin Notification";
                $notification->user_id = $user->id;
                $notification->save();
                if ($user->status == 'online' || $user->status != "not_blocked")
                    $user->notify(new AdminNotification($notification, $user));

            } else {
                $users = User::whereIn("role", ["user", "driver"])->get();
                foreach ($users as $user) {
                    $notification->fill($request->except($notification->translatable));
                    if (!is_null($notification->translatable)) {
                        foreach ($notification->translatable as $attr) {
                            $trans = [];
                            foreach (Language::all() as $language) {
                                $var = $attr . "_" . $language->code;
                                $trans[$language->code] = $request->$var;
                            }
                            $notification->$attr = $trans;
                        }
                    }
                    $notification->type = "Admin Notification";
                    $notification->save();

                    $user->notify(new AdminNotification($notification, $user));
                }
            }
            Session::flash('message', trans('app.success message', ['action' => trans('app.create')]));
            Session::flash('class', 'success');

            return redirect()->back();

        } catch (\Exception $e) {
            dd($e);
            Session::flash('message', trans('app.error message', ['action' => trans('app.create')]));
            Session::flash('class', 'danger');

            return redirect()->back();
        }
    }

}
