<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         $this->middleware('guest')->except('logout');
    }

    public function showLoginForm()
    {
        if (Auth::user()) {
            $role = Auth::user()->role;
            if ($role == "admin" || $role == "entry")
                return redirect()->route('home');
            else
                return redirect()->route('front.home');
        } else {
            return view('auth.login');
        }
    }

    public function authenticated(Request $request, $user)
    {
        if ($user->role == "admin" || $user->role == "entry")
            $this->redirectTo = "/admin/home";
        else
            $this->redirectTo = "/home";
    }

    public function username()
    {
        return 'mobile';
    }

    public function logout()
    {
		session()->forget('user');
        Auth::logout();
        return redirect()->route("login");
    }

}
